package com.example.sefinsa_app.utilities;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Toast;

import androidx.appcompat.app.AlertDialog;

import com.example.sefinsa_app.R;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;

public class NetworkChangeListener extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        // Verifica si hay conexión a Internet
        if (!NetworkChange.isConnectedToInternet(context)) {
            // Cambia el color de la barra de estado si está en un dispositivo Lollipop o superior
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                Window window = ((Activity) context).getWindow();
                window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
                window.setStatusBarColor(context.getResources().getColor(R.color.danger));
            }

            // Muestra un Toast en lugar de un AlertDialog
            Toast.makeText(context, "Te has desconectado de internet, revisa tu conexión", Toast.LENGTH_LONG).show();
        } else {
            // Restaura el color de la barra de estado si hay conexión
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                Window window = ((Activity) context).getWindow();
                window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
                window.setStatusBarColor(context.getResources().getColor(R.color.blue_700));
            }
        }
    }
}
